VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Contact"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Public Enum PhoneType
  HomePhone
  WorkPhone
  CellPhone
End Enum

Public Enum EMailType
  HomeEMail
  WorkEMail
End Enum

Private mstrID As String
Private mstrLastName As String
Private mstrFirstName As String
Private mstrAddress1 As String
Private mstrAddress2 As String
Private mstrCity As String
Private mstrState As String
Private mstrZipCode As String
Private mstrPhoneWork As String
Private mstrPhoneHome As String
Private mstrPhoneCell As String
Private mstrEMailWork As String
Private mstrEMailHome As String

Private mblnIsDeleted As Boolean
Private mblnIsDirty As Boolean
Private mblnIsNew As Boolean
Private Sub Class_Initialize()
  mblnIsNew = True
End Sub

Public Property Get ID() As String
  ID = mstrID
End Property

Public Property Get LastName() As String
  LastName = mstrLastName
End Property

Public Property Let LastName(ByVal Value As String)

  If Len(Value) <= 50 Then
    mstrLastName = Value
  Else
    Err.Raise vbObjectError + 1001, , "String too long"
  End If
  mblnIsDirty = True

End Property
Public Property Get FirstName() As String
  FirstName = mstrFirstName
End Property

Public Property Let FirstName(ByVal Value As String)

  If Len(Value) <= 50 Then
    mstrFirstName = Value
  Else
    Err.Raise vbObjectError + 1001, , "String too long"
  End If
  mblnIsDirty = True

End Property

Public Property Get Address1() As String
  Address1 = mstrAddress1
End Property

Public Property Let Address1(ByVal Value As String)

  If Len(Value) <= 50 Then
    mstrAddress1 = Value
  Else
    Err.Raise vbObjectError + 1001, , "String too long"
  End If
  mblnIsDirty = True

End Property

Public Property Get Address2() As String
  Address2 = mstrAddress2
End Property

Public Property Let Address2(ByVal Value As String)

  If Len(Value) <= 50 Then
    mstrAddress2 = Value
  Else
    Err.Raise vbObjectError + 1001, , "String too long"
  End If
  mblnIsDirty = True

End Property

Public Property Get City() As String
  City = mstrCity
End Property

Public Property Let City(ByVal Value As String)

  If Len(Value) <= 30 Then
    mstrCity = Value
  Else
    Err.Raise vbObjectError + 1001, , "String too long"
  End If
  mblnIsDirty = True

End Property

Public Property Get State() As String
  State = mstrState
End Property

Public Property Let State(ByVal Value As String)

  If Len(Value) <= 20 Then
    mstrState = Value
  Else
    Err.Raise vbObjectError + 1001, , "String too long"
  End If
  mblnIsDirty = True

End Property

Public Property Get ZipCode() As String
  ZipCode = mstrZipCode
End Property

Public Property Let ZipCode(ByVal Value As String)

  If Len(Value) <= 20 Then
    mstrZipCode = Value
  Else
    Err.Raise vbObjectError + 1001, , "String too long"
  End If
  mblnIsDirty = True

End Property


Public Property Get Phone(ByVal PhoneType As PhoneType) As String

  If PhoneType = WorkPhone Then
    Phone = mstrPhoneWork
  ElseIf PhoneType = HomePhone Then
    Phone = mstrPhoneHome
  ElseIf PhoneType = CellPhone Then
    Phone = mstrPhoneCell
  Else
    Phone = ""
  End If

End Property

Public Property Let Phone(ByVal PhoneType As PhoneType, _
                          ByVal Value As String)

  If Len(Value) > 20 Then
    Err.Raise vbObjectError + 1001, , "String too long"
  Else
    If PhoneType = WorkPhone Then
      mstrPhoneWork = Value
    ElseIf PhoneType = HomePhone Then
      mstrPhoneHome = Value
    ElseIf PhoneType = CellPhone Then
      mstrPhoneCell = Value
    End If
    mblnIsDirty = True
  End If

End Property

Public Property Get EMail(ByVal EMailType As EMailType) As String

  If EMailType = WorkEMail Then
    EMail = mstrEMailWork
  ElseIf EMailType = HomeEMail Then
    EMail = mstrEMailHome
  Else
    EMail = ""
  End If

End Property

Public Property Let EMail(ByVal EMailType As EMailType, _
                          ByVal Value As String)

  If Len(Value) > 100 Then
    Err.Raise vbObjectError + 1001, , "String too long"
  Else
    If EMailType = WorkEMail Then
      mstrEMailWork = Value
    ElseIf EMailType = HomeEMail Then
      mstrEMailHome = Value
    End If
    mblnIsDirty = True
  End If

End Property

Private Sub Fetch(ByVal ID As String)

  Dim objCN As ADODB.Connection
  Dim objCM As ADODB.Command
  Dim objRS As ADODB.Recordset
   
  Set objCN = New Connection
  objCN.Open DB_CONN
   
  Set objCM = New Command
  With objCM
    .ActiveConnection = objCN
    .CommandText = "getContact"
    .CommandType = adCmdStoredProc
    .Parameters.Append .CreateParameter("id", adGUID, _
                        adParamInput, -1, ID)
    Set objRS = .Execute
  End With
   
  With objRS
    mstrID = objRS("ID")
    mstrLastName = objRS("LastName")
    mstrFirstName = objRS("FirstName")
    mstrAddress1 = objRS("Address1")
    mstrAddress2 = objRS("Address2")
    mstrCity = objRS("City")
    mstrState = objRS("State")
    mstrZipCode = objRS("ZipCode")
  End With

  Set objRS = objRS.NextRecordset
  With objRS
    Do While Not .EOF
      If objRS("PhoneType") = PhoneType.WorkPhone Then
         mstrPhoneWork = objRS("Phone")
      ElseIf objRS("PhoneType") = PhoneType.HomePhone Then
         mstrPhoneHome = objRS("Phone")
      ElseIf objRS("PhoneType") = PhoneType.CellPhone Then
         mstrPhoneCell = objRS("Phone")
      End If
      .MoveNext
    Loop
  End With
   
  Set objRS = objRS.NextRecordset
  With objRS
    Do While Not .EOF
      If objRS("EMailType") = EMailType.WorkEMail Then
        mstrEMailWork = objRS("EMail")
      ElseIf objRS("EMailType") = EMailType.HomeEMail Then
        mstrEMailHome = objRS("EMail")
      End If
        .MoveNext
    Loop
  End With
   
  Set objRS = Nothing
  Set objCM = Nothing
  objCN.Close
  Set objCN = Nothing
   
  mblnIsNew = False
  mblnIsDeleted = False
  mblnIsDirty = False

End Sub

Public Sub Load(ByVal ID As String)
  Fetch ID
End Sub

Private Sub Update()

  Dim objCN As ADODB.Connection
  Dim objCM As ADODB.Command
   
  Set objCN = New Connection
  objCN.Open DB_CONN
   
  Set objCM = New Command
  With objCM
    .ActiveConnection = objCN
    .CommandType = adCmdStoredProc
  End With
   
  If mblnIsDeleted Then
    With objCM
      .CommandText = "deleteContact"
      .Parameters.Append .CreateParameter("id", adGUID, adParamInput, _
                                           4, mstrID)
      .Execute
    End With
    mblnIsNew = True
  Else
    If mblnIsNew Then
      With objCM
        .CommandText = "addContact"
        .Parameters.Append .CreateParameter("@id", adGUID, _
                                               adParamOutput)
      End With
    Else
      With objCM
        .CommandText = "updateContact"
        .Parameters.Append .CreateParameter("@id", adGUID, _
                                             adParamInput, 4, mstrID)
      End With
    End If
    With objCM
      .Parameters.Append .CreateParameter("@lname", adVarChar, _
                                           adParamInput, 50, mstrLastName)
      .Parameters.Append .CreateParameter("@fname", adVarChar, _
                                           adParamInput, 50, mstrFirstName)
      .Parameters.Append .CreateParameter("@add1", adVarChar, _
                                           adParamInput, 50, mstrAddress1)
      .Parameters.Append .CreateParameter("@add2", adVarChar, _
                                           adParamInput, 50, mstrAddress2)
      .Parameters.Append .CreateParameter("@city", adVarChar, _
                                           adParamInput, 30, mstrCity)
      .Parameters.Append .CreateParameter("@state", adVarChar, _
                                           adParamInput, 20, mstrState)
      .Parameters.Append .CreateParameter("@zip", adVarChar, _
                                           adParamInput, 20, mstrZipCode)
      .Parameters.Append .CreateParameter("@phome", adVarChar, _
                                           adParamInput, 30, mstrPhoneHome)
      .Parameters.Append .CreateParameter("@pwork", adVarChar, _
                                           adParamInput, 30, mstrPhoneWork)
      .Parameters.Append .CreateParameter("@pcell", adVarChar, _
                                           adParamInput, 30, mstrPhoneCell)
      .Parameters.Append .CreateParameter("@emhome", adVarChar, _
                                           adParamInput, 100, mstrEMailHome)
      .Parameters.Append .CreateParameter("@emwork", adVarChar, _
                                           adParamInput, 100, mstrEMailWork)
      .Execute
      Set .ActiveConnection = Nothing
      If mblnIsNew Then
        mstrID = objCM.Parameters("@id").Value
        mblnIsNew = False
      End If
    End With
  End If
   
  Set objCM = Nothing
  Set objCN = Nothing
  mblnIsDeleted = False
  mblnIsDirty = False

End Sub

Public Sub Save()

  If Not mblnIsDeleted Then
    If Len(mstrLastName) = 0 Then
      Err.Raise vbObjectError + 1002, , "Last name required"
    End If
    If Len(mstrFirstName) = 0 Then
      Err.Raise vbObjectError + 1003, , "First name required"
    End If
    If Len(mstrCity) = 0 Then
      Err.Raise vbObjectError + 1004, , "City required"
    End If
    If Len(mstrState) = 0 Then
      Err.Raise vbObjectError + 1005, , "State required"
    End If
  End If

  If mblnIsDirty Then Update

End Sub

Public Sub Delete()

  mblnIsDirty = True
  mblnIsDeleted = True
  Save

End Sub
Public Sub DeleteContact(ByVal ID As String)

  mstrID = ID
  Delete

End Sub















